Attribute VB_Name = "StarIOPort"
Option Base 0
Option Explicit

' StarPrinterStatus_2
' -------------------
' This structure represents the printer's status.
'
Public Type StarPrinterStatus_2
    ' printer status 1
    coverOpen As Long
    offline As Long
    compulsionSwitch As Long
    
    ' printer status 2
    overTemp As Long
    unrecoverableError As Long
    cutterError As Long
    mechError As Long
    headThermistorError As Long
    
    ' printer status 3
    receiveBufferOverflow As Long
    pageModeCmdError As Long
    blackMarkError As Long
    presenterPaperJamError As Long
    headUpError As Long
    voltageError As Long
    
    ' printer status 4
    receiptBlackMarkDetection As Long
    receiptPaperEmpty As Long
    receiptPaperNearEmptyInner As Long
    receiptPaperNearEmptyOuter As Long
    
    ' printer status 5
    presenterPaperPresent As Long
    peelerPaperPresent As Long
    stackerFull As Long
    slipTOF As Long
    slipCOF As Long
    slipBOF As Long
    validationPaperPresent As Long
    slipPaperPresent As Long
    
    ' printer status 6
    etbAvailable As Long
    etbCounter As Byte
    
    ' printer status 7
    presenterState As Byte
    
    ' raw
    rawLength As Long
    raw(0 To 62) As Byte
End Type


' OpenPort
' --------
' This function opens a connection to the port specified.
' 
' Parameters: portName               - string taking on one of these forms:
'                                      "usbven:" which opens the first available USB Vendor Class device
'                                      "usbven:sNsNsNsN" which opens the USB Vendor Class device with that serial number
'                                      "usbven:COMx" which opens the USB Vendor Class device that has been assigned to COMx (i.e. 'COM4' or 'COM17')
'                                      "usbprn:Queue Name" which opens the USB Printer Class device associated with the specified printer queue
'                                      "COMx" which opens the real serial port (i.e. 'COM1')
'                                      "LPTx" which opens the real parallel port (i.e. 'LPT1')
'                                      "tcp:nnn.nnn.nnn.nnn" which opens the network printer at the specified IP address (i.e. '192.168.11.3')
'             portSettings           - string of the form "9600,n,8,1,h" for serial, "" for all others
'             ioRequestTimeoutMillis - millisecond timeout controlling internally used communication APIs (this parameter garantees that all of the below APIs will complete in a bounded amount of time, but does NOT garantee the exact timeout length)
' Returns:    0 on failure
'                 or
'             the created port (opaque pointer in C++ terminology)
' Notes:      1. In the case of serial, the portSettings string contains the
'                following fields:
'                    baud: 38400, 19200, 9600, 4800, 2400
'                    parity: n, e, o
'                    data-bits: 8, 7
'                    stop-bits: 1
'                    flow-ctrl: n, h
'
Public Declare Function OpenPortA Lib "starioport.dll" (ByVal portName As String, ByVal portSettings As String, ByVal timeOut As Long) As Long


' ClosePort
' --------
' This function closes a connection to the port specified.
' 
' Parameters: port - the previously created port
' Returns:    0 on failure
'               or
'             1 on success
'
Public Declare Function ClosePort Lib "starioport.dll" (ByVal port As Long) As Long


' ReadPort
' --------
' This function reads data from the device.
' 
' Parameters: port             - the previously created port
'             readBuffer       - a byte buffer into which data is read
'             size             - size in bytes to read
'             sizeCommunicated - out variable into which the actual read size is written
' Returns:    0 on failure
'               or
'             1 on success
' Notes:      Under some interface types, this function will return SM_TRUE even when no data was read in.  Your application should call
'             this function a limited number of times until the expected data has been read in or until an application determined
'             retry threshold has been reached.
'
Public Declare Function ReadPort Lib "starioport.dll" (ByVal port As Long, ByRef readBuffer As Byte, ByVal size As Long, ByRef sizeCommunicated As Long) As Long

                                          
' WritePort
' --------
' This function writes data to the device.
' 
' Parameters: port             - the previously created port
'             writeBuffer      - a byte buffer containing the write data
'             size             - size in bytes to write
'             sizeCommunicated - out variable into which the actual write size is written
' Returns:    0 on failure
'               or
'             1 on success
' Notes:      Under some interface types, this function will return SM_TRUE even when no data was written out.  Your application should call
'             this function a limited number of times until all the data has been written out or until an application determined
'             retry threshold has been reached.
'
Public Declare Function WritePort Lib "starioport.dll" (ByVal port As Long, ByRef command As Byte, ByVal size As Long, ByRef communicated As Long) As Long


' GetOnlineStatus
' --------
' This function retreives the device's online status.
' 
' Parameters: port         - the previously created port
'             onlineStatus - out variable into which the device's online status is written (0 = offline, 1 = online)
' Returns:    0 on failure
'               or
'             0 on success
'
Public Declare Function GetOnlineStatus Lib "starioport.dll" (ByVal port As Long, ByRef onlineStatus As Long) As Long


' GetParsedStatusEx
' --------
' This function retreives the device's detailed status.
' 
' Parameters: port          - the previously created port
'             printerStatus - an StarPrinterStatus_2 structure where the device's detailed status is written
'             level         - designates the level of status structure (must be 2)
' Returns:    0 on failure
'               or
'             1 on success
'
Public Declare Function GetParsedStatusEx Lib "starioport.dll" (ByVal port As Long, ByRef printerStatus As StarPrinterStatus_2, ByVal level As Long) As Long


' BeginCheckedBlockEx
' --------
' This function initiates a checked block printing operation and returns the devices detailed status.
'
' Parameters: port          - long containing the address of the port
'             printerStatus - an StarPrinterStatus_2 structure where the device's detailed status is written
'             level         - designates the level of status structure (must be 2)
' Returns:    0 on failure
'               or
'             1 on success
'
Public Declare Function BeginCheckedBlockEx Lib "starioport.dll" (ByVal port As Long, ByRef printerStatus As StarPrinterStatus_2, ByVal level As Long) As Long


' EndCheckedBlockEx
' ---------------
' This function ends a checked block printing operation and returns the devices detailed status.
' This function does not return until either the printer has successfully printed all data or has gone offline in error.
' If the starPrinterStatus structure indicates that the printer is online upon return than all data was successfully printed.
'
' Parameters: port          - long containing the address of the port
'             printerStatus - an StarPrinterStatus_2 structure where the device's detailed status is written
'             level         - designates the level of status structure (must be 2)
' Returns:    0 on failure
'               or
'             1 on success
'
Public Declare Function EndCheckedBlockEx Lib "starioport.dll" (ByVal port As Long, ByRef printerStatus As StarPrinterStatus_2, ByVal level As Long) As Long


' ResetDevice
' --------
' This function resets the device at the hardware level.
'
' Parameters: port - long containing the address of the port
' Returns:    0 on failure
'               or
'             1 on success
'
Public Declare Function ResetDevice Lib "starioport.dll" (ByVal port As Long) As Long

